/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.AddRemoveTagMessage;
import com.ldtteam.structurize.network.messages.BuildToolPasteMessage;
import com.ldtteam.structurize.network.messages.GenerateAndPasteMessage;
import com.ldtteam.structurize.network.messages.GenerateAndSaveMessage;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.LSStructureDisplayerMessage;
import com.ldtteam.structurize.network.messages.MultiBlockChangeMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.network.messages.SchematicSaveMessage;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.network.messages.StructurizeStylesMessage;
import com.ldtteam.structurize.network.messages.UndoMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String LATEST_PROTO_VER = "1.1";
    private static final String ACCEPTED_PROTO_VERS = "1.1";
    private final SimpleChannel rawChannel;

    public NetworkChannel(String channelName) {
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("structurize", channelName), () -> "1.1", "1.1"::equals, "1.1"::equals);
    }

    public void registerCommonMessages() {
        int idx = 0;
        this.registerMessage(++idx, MultiBlockChangeMessage.class, MultiBlockChangeMessage::new);
        this.registerMessage(++idx, BuildToolPasteMessage.class, BuildToolPasteMessage::new);
        this.registerMessage(++idx, GenerateAndPasteMessage.class, GenerateAndPasteMessage::new);
        this.registerMessage(++idx, GenerateAndSaveMessage.class, GenerateAndSaveMessage::new);
        this.registerMessage(++idx, LSStructureDisplayerMessage.class, LSStructureDisplayerMessage::new);
        this.registerMessage(++idx, RemoveBlockMessage.class, RemoveBlockMessage::new);
        this.registerMessage(++idx, RemoveEntityMessage.class, RemoveEntityMessage::new);
        this.registerMessage(++idx, SaveScanMessage.class, SaveScanMessage::new);
        this.registerMessage(++idx, ReplaceBlockMessage.class, ReplaceBlockMessage::new);
        this.registerMessage(++idx, ScanOnServerMessage.class, ScanOnServerMessage::new);
        this.registerMessage(++idx, SchematicRequestMessage.class, SchematicRequestMessage::new);
        this.registerMessage(++idx, SchematicSaveMessage.class, SchematicSaveMessage::new);
        this.registerMessage(++idx, ServerUUIDMessage.class, ServerUUIDMessage::new);
        this.registerMessage(++idx, StructurizeStylesMessage.class, StructurizeStylesMessage::new);
        this.registerMessage(++idx, UndoMessage.class, UndoMessage::new);
        this.registerMessage(++idx, UpdateScanToolMessage.class, UpdateScanToolMessage::new);
        this.registerMessage(++idx, AddRemoveTagMessage.class, AddRemoveTagMessage::new);
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz, Function<PacketBuffer, MSG> initializer) {
        this.rawChannel.registerMessage(id, msgClazz, IMessage::toBytes, initializer, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            if (msg.getExecutionSide() != null && packetOrigin.equals((Object)msg.getExecutionSide())) {
                Log.getLogger().warn("Receving {} at wrong side!", (Object)msg.getClass().getName());
                return;
            }
            ctx.enqueueWork(() -> msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        });
    }

    public void sendToServer(IMessage msg) {
        this.rawChannel.sendToServer((Object)msg);
    }

    public void sendToPlayer(IMessage msg, ServerPlayerEntity player) {
        this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public void sendToOrigin(IMessage msg, NetworkEvent.Context ctx) {
        ServerPlayerEntity player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToPosition(IMessage msg, PacketDistributor.TargetPoint pos) {
        this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), (Object)msg);
    }

    public void sendToEveryone(IMessage msg) {
        this.rawChannel.send(PacketDistributor.ALL.noArg(), (Object)msg);
    }

    public void sendToTrackingEntity(IMessage msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingEntityAndSelf(IMessage msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingChunk(IMessage msg, Chunk chunk) {
        this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)msg);
    }
}

